
' Changer les structures en classe pour voir les diffrences de comportement.
Structure FOO
    Public x, y As Integer
End Structure

' Un autre type de valeur.
Structure PersonStruct
    Public Name As String
    Public Age As Integer
    Public Sub DisplayStats()
        Console.WriteLine("Nom : {0} Age : {1}", Name, Age)
    End Sub

    Public Sub New(ByVal n As String, ByVal a As Integer)
        Name = n : Age = a
    End Sub
End Structure

' Un autre type de rfrence.
Class PersonClass
    Public Name As String
    Public Age As Integer
    Public Sub DisplayStats()
        Console.WriteLine("Nom : {0} Age : {1}", Name, Age)
    End Sub

    Public Sub New(ByVal n As String, ByVal a As Integer)
        Name = n : Age = a
    End Sub
End Class

' Type de valeur contenant un type de rfrence.
Class TheRefType
    Public x As String
    Sub New(ByVal s As String)
        x = s
    End Sub
End Class

Structure InnerRef
    Public refType As TheRefType
    Public structData As Integer
    Sub New(ByVal s As String)
        refType = New TheRefType(s)
    End Sub
End Structure

Module Module1

    Sub Main()
        ' Le mot-cl New est facultatif
        ' quand on utilise le constructeur par dfaut.
        Console.WriteLine("Construction d'une nouvelle structure FOO")
        Dim f1 As FOO '= New FOO()
        f1.x = 100
        f1.y = 100

        ' Ceci provoque une copie de f1,
        ' qui est stock dans f2.
        Console.WriteLine("Affectation de f2  f1")
        Dim f2 As FOO = f1

        ' Voici F1.
        Console.WriteLine("F1.x = {0}", f1.x)
        Console.WriteLine("F1.y = {0}", f1.y)

        ' Voici F2.
        Console.WriteLine("F2.x = {0}", f2.x)
        Console.WriteLine("F2.y = {0}", f2.y)

        ' Cela modifie f2.x. Cela ne va PAS changer f1.x.
        Console.WriteLine("Modification de f2.x")
        f2.x = 900

        ' Affichage  nouveau.
        Console.WriteLine("F2.x = {0}", f2.x)
        Console.WriteLine("F1.x = {0}", f1.x)

        'Console.WriteLine("{0}Now some people.{0}", Constants.vbLf)
        ' Crer une rfrence d'objet sur le tas manag.
        Dim fred As PersonClass = New PersonClass("Fred", 9)
        fred.DisplayStats()

        ' Ceci conduit  deux rfrences au
        ' au mme objet sur le tas.
        Dim fredRef As PersonClass = fred
        fred.Age = 2000 ' Ceci va changer fred et fredRef!
        fred.DisplayStats()
        Console.Write("Fred Ref: ")
        fredRef.DisplayStats()

        ' Crer une valeur sur le tas.
        Dim mary As PersonStruct = New PersonStruct("Mary", 9)
        mary.DisplayStats()

        ' Ceci provoque une copie, rsultant en deux structures sur le tas.
        Dim jane As PersonStruct = New PersonStruct("Jane", 49)
        jane.Age = 2000
        jane.DisplayStats()
        mary.DisplayStats()

        ' Crer un type valeur contenant un type rfrence.
        Dim valWithRef As New InnerRef("Valeur initiale")
        valWithRef.structData = 666
        Dim valWithRef2 As InnerRef
        valWithRef2 = valWithRef
        valWithRef2.refType.x = "J'ai t modifi par ref 2 !"
        valWithRef2.structData = 777
        Console.WriteLine("La valeur de valWithRef.refType.x est {0}", valWithRef.refType.x)
        Console.WriteLine("La valeur de valWithRef2.refType.x est {0}", valWithRef2.refType.x)
        Console.WriteLine("La valeur de valWithRef.structData est {0}", valWithRef.structData)
        Console.WriteLine("La valeur de valWithRef2.structData est {0}", valWithRef2.structData)
    End Sub
End Module
